package ch.sahits.game.openpatrician.model.city.cityhall;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;

/**
 * Treasury of the city. The transient values hold the values of the current month.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ITreasury {
    /**
     * Retrieve the current height of the taxes.
     * @return current head tax
     */
    double getCurrentHeadTaxValue();

    /**
     * Retrieve the current property tax.
     * @return current proerty tax
     */
    double getCurrentPropertyTax();

    /**
     * Amount of the property and head taxes up to date this year.
     * @return paid taxes for the current year
     */
    long getPaidTaxes();

    /**
     * Amount of the paid special taxes.
     * @return paid special taxes for the current year
     */
    long getPaidSpecialTaxes();

    /**
     * Monthly costs of the city guard.
     * @return monthly costs for the city guards
     */
    int getCityGuardCosts();

    /**
     * Costs for the building of city walls and towers up to date.
     * This value is only positive if there is a building being built.
     * @return building costs for the city walls.
     */
    int getBuildingCosts();

    /**
     * Costs for paying the outrigger.
     * @return costs for the outrigger
     */
    int getOutriggerCosts();

    /**
     * Paid ransom to prevent/abort siege.
     * @return costs to prevent a siege.
     */
    int getSiegeCosts();

    /**
     * Costs and fees that the city has to have payed up to this date in the current year.
     * Included here are also stolen amounts.
     * @return other costs.
     */
    int getOtherCosts();

    /**
     * All other income like donations.
     * @return other income
     */
    int getOtherIncome();

    /**
     * All the donated amount.
     * @return donations
     */
    int getDonations();

    /**
     * Retrieve the whole amount in the treasury.
     * @return cash in the treasury.
     */
    long getCash();

    /**
     * Double property for the current head tax value.
     * @return current head tax value
     */
    DoubleProperty currentHeadTaxValueProperty();

    DoubleProperty currentPropertyTaxProperty();

    LongProperty paidTaxesProperty();

    LongProperty paidSpecialTaxesProperty();

    IntegerProperty cityGuardCostsProperty();

    IntegerProperty buildingCostsProperty();

    IntegerProperty outriggerCostsProperty();

    IntegerProperty siegeCostsProperty();

    IntegerProperty otherCostsProperty();

    IntegerProperty otherIncomeProperty();

    IntegerProperty donationsProperty();

    LongProperty cashProperty();
}
