package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 13, 2016
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.MODEL, EClassCategory.PROTOTYPE_BEAN})
public class ShipAuction extends AbstractAuction implements IShipAuction {
    @Getter
    private final IShip auctionedShip;

    /**
     * Create a ship auction where the ship did not have a previous owner.
     * @param auctionDate date of the auction
     * @param startingBid first bid of the auction
     * @param auctionedShip ship to be auctioned
     */
    public ShipAuction(LocalDateTime auctionDate, int startingBid, IShip auctionedShip) {
        super(auctionDate, startingBid);
        this.auctionedShip = auctionedShip;
    }

    /**
     * Create a ship auction together with it's owner.
     * @param auctionDate date of the auction
     * @param startingBid first bid of the auction
     * @param owner of the ship
     * @param auctionedShip ship to be auctioned
     */
    public ShipAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner, IShip auctionedShip) {
        super(auctionDate, startingBid, owner);
        this.auctionedShip = auctionedShip;
    }
}
