package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 21, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ChurchState implements IChurch {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(ChurchState.class);

    @Getter
    private EChurchExtension extensionLevel = EChurchExtension.NONE;
    @Getter
    private int collectedDonationsForExtension = 0;

    @Override
    public void upgrade() {
        Optional<EChurchExtension> next = extensionLevel.getNextExtensionLevel();
        if (next.isPresent()) {
            extensionLevel = next.get();
            collectedDonationsForExtension = 0;
        } else {
            LOGGER.warn("Church cannot be extended as it is already extended to its max level.");
        }
    }

    public void makeDonation(int amount) {
        collectedDonationsForExtension += amount;
    }
}
