package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.time.Duration;
import java.time.LocalDateTime;


/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Builder
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class Debt implements IDebt {
    @Getter
    private final ICitizen debitor;
    @Getter
    private final ICreditor creditor;
    @Getter
    @NonNull
    private final LocalDateTime dueDate;
    @Getter
    private final double interest;
    @Getter
    private final int amount;
    @NonNull
    private final LocalDateTime loanTakeOut;

    @Override
    public long getLoanedDuration(LocalDateTime now) {
        Duration duration = Duration.between(loanTakeOut, now);
        return duration.toDays() + 1;
    }

    @Override
    public long getTotalDuration() {
        Duration duration = Duration.between(loanTakeOut, dueDate);
        return duration.toDays() + 1;
    }

    @Override
    public String toString() {
        return "Debt{" +
                "debitor=" + debitor.getName() + " " + debitor.getLastName() +
                ", dueDate=" + dueDate +
                ", interest=" + interest +
                ", amount=" + amount +
                ", loanTakeOut=" + loanTakeOut +
                '}';
    }
}
