package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;

import java.time.LocalDateTime;

/**
 * Debt of a citizen to another citizen.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface IDebt {
    /**
     * Retrieve the citizen that is in debt.
     * @return citizen whom the debt is owned.
     */
    ICitizen getDebitor();

    /**
     * Retrieve the citizen that owns the debt.
     * @return citizen who took out the loan.
     */
    ICreditor getCreditor();

    /**
     * Retrieve the date when the debt has to be payed back.
     * @return date when the debt has to be payed back.
     */
    LocalDateTime getDueDate();

    /**
     * Retrieve the duration in full days since taking the loan.
     * @param now date per which the number of days are to be calculated.
      * @return number of days of the loan untill <code>now</code>
     */
    long getLoanedDuration(LocalDateTime now);

    /**
     * Retrieve the total duration of the loan in days.
     * @return number of days from start until the due date.
     */
    long getTotalDuration();

    /**
     * Interest of the debt over the whole duration.
     * @return interest rate.
     */
    double getInterest();

    /**
     * Amount of money indebted without interest.
     * @return loaned amount of money.
     */
    int getAmount();
}
