package ch.sahits.game.openpatrician.model.map;


import javafx.geometry.Point2D;

/**
 * Defining a section on the map.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IMapSection {
	/**
	 * Retrieve the offset on IMap in X direction
	 * @return horizontal offset of the map section
	 */
	int getXOffset();
	/**
	 * Retrieve the offset on IMap in Y direction
	 * @return vertical offset of the map section
	 */
	int getYOffset();
	/**
	 * Retrieve the width and height of the section
	 * @return dimension of one map section.
	 */
	int getDimension();
	/**
	 * Retrieve the location of the cross in the coordinates of IMap
	 * @return location of the "x marks the spot"
	 */
	Point2D getCross();
}
