package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.Optional;

/**
 * Relations of a contract broker to the cities and player.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Apr 30, 2018
 */
@Getter
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class ContractBrokerConnections {
    private final IContractBroker contractBroker;
    private final ICity city;
    @Setter
    @OptionalType(IPlayer.class)
    private Optional<IPlayer> assignedPlayer = Optional.empty();
    @Setter
    private LocalDateTime deadline;

    public ContractBrokerConnections(IContractBroker contractBroker, ICity city) {
        this.contractBroker = contractBroker;
        this.city = city;
    }
}
