package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;


/**
 * A smuggler request delivery of some wares into another city.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface ISmuggler extends ISideRoomPerson {
	/**
	 * Retrieve the amount of ware that is to be smuggled.
	 * The amount is in barrels.
	 * @return amount of the goods that should be smuggled.
	 */
	int getAmount();
	/**
	 * Destination city.
	 * @return city where the goods should be smuggled to.
	 */
	ICity getDestination();

	/**
	 * Retrieve hte premium for the smuggling.
	 * @return premium for smuggling
	 */
	int getPremium();

	/**
	 * Set the amount of goods.
	 * @param amount to be smuggled.
	 */
	void setAmount(int amount);

	/**
	 * Set the premium.
	 * @param premium for task completion
	 */
	void setPremium(int premium);

	/**
	 * Set the destination
	 * @param destination where the goods are smuggled to.
	 */
	void setDestination(ICity destination);
}
