package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

import java.time.LocalDateTime;
import java.time.Period;

@RequiredArgsConstructor
@Getter
@EqualsAndHashCode
@ToString
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class PersonalData implements IPersonalData {

	private final String name;
	private final String lastName;
	private final boolean male;
	private final ICity birthPlace;
	private final LocalDateTime birthDate;


	@Override
	public int getAge(LocalDateTime now) {
		return Period.between(birthDate.toLocalDate(), now.toLocalDate()).getYears();
	}

}
