package ch.sahits.game.openpatrician.model.player;


import javafx.scene.paint.Color;

/**
 * Color used for identifying a human player.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 11, 2017
 */
public enum EPlayerColor {
    /** #0000ff. */
    BLUE(Color.BLUE),
    /** #7cfc00. */
    GREEN(Color.LAWNGREEN),
    /** #008000. */
    DARKGREEN(Color.GREEN),
    /** #ffff00. */
    YELLOW(Color.YELLOW),
    /** #800080. */
    PURPLE(Color.PURPLE),
    /** #ffc0cb. */
    PINK(Color.PINK),
    /** #ffa500. */
    ORANGE(Color.ORANGE),
    /** #8b0000. */
    BURGUNDY(Color.DARKRED),
    /** #add8e6. */
    LIGHTBLUE(Color.LIGHTBLUE),
    /** #40e0d0. */
    TURQUIS(Color.TURQUOISE),
    /** #00008b. */
    DARKBLUE(Color.DARKBLUE),
    /** #ff00ff. */
    MAGENTA(Color.MAGENTA),
    /** #800000. */
    MAROON(Color.MAROON),
    /** #9acd32. */
    YELLOWGREEN(Color.YELLOWGREEN),
    /** #00ffff. */
    CYAN(Color.CYAN),
    /** #fa8072. */
    SALMON(Color.SALMON);
    private final Color color;

    EPlayerColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return color;
    }
}
