package ch.sahits.game.openpatrician.model.player;

/**
 * Preferences for trade strategies giving indication for best matches.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Jun 17, 2018
 */
public enum ETradeStrategyPreference {
    /** Prefer the strategy if the vessel is a convoy. */
    CONVOY,
    /** Prefer the strategy if the vessel is capable of travelling a river. */
    RIVER_SHIP,
    /** Prefer the strategy if the vessel is a fast one. */
    FAST_SHIP,
    /** Prefer the strategy if the vessel is a snaikka. */
    SNAIKKA,
    /** Prefer the strategy if the vessel is a crayer. */
    CRAYER,
    /** Prefer the strategy if the vessel is a cog. */
    COG,
    /** Prefer the strategy if the vessel is a holk. */
    HOLK,
    /** Prefer the strategy if the vessel is heavily armed. */
    HEAVY_ARMED,
    /** Prefer the strategy if the vessel has many sailors. */
    MANY_SAILORS

}
