package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;

/**
 * Interface defining the strategy for taking a loan.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jun 12, 2016
 */
public interface IAITakeLoanStrategy {
    /**
     * Check if the player should take out a loan.
     * @param player to be checked.
     * @return true if a loan should be taken.
     */
    boolean shouldTakeLoan(IAIPlayer player);

    /**
     * Take a loan in the city.
     * @param player that takes out the loan
     * @param city where the loan is taken.
     */
    void takeLoan(IAIPlayer player, ICity city);
}
