package ch.sahits.game.openpatrician.model.product;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Aug 14, 2016
 */
public abstract class BasePriceCalulation implements IPriceCalculationV2 {
    /**
     * Retreive the minimal value from tradable dependent if we are buying or selling.
     * @param tradable holding the min value
     * @param buy flag indicating if we are buying or selling
     * @return appropriate value for min based on the <code>buy</code> flag.
     */
    protected int getMinValue(ITradable tradable, boolean buy) {
        if (buy) {
            return tradable.getMinValueBuy();
        } else {
            return tradable.getMinValueSell();
        }
    }
    /**
     * Retreive the maximal value from tradable dependent if we are buying or selling.
     * @param tradable holding the max value
     * @param buy flag indicating if we are buying or selling
     * @return appropriate value for max based on the <code>buy</code> flag.
     */
    protected int getMaxValue(ITradable tradable, boolean buy) {
        if (buy) {
            return tradable.getMaxValueBuy();
        } else {
            return tradable.getMaxValueSell();
        }
    }

    /**
     * Retreive the saturation value from tradable dependent if we are buying or selling.
     * @param tradable holding the max value
     * @param buy flag indicating if we are buying or selling
     * @return appropriate value for saturation based on the <code>buy</code> flag.
     */
    protected int getSaturation(ITradable tradable, boolean buy) {
        if (buy) {
            return tradable.getMarketSaturationForBuying();
        } else {
            return tradable.getMarketSaturationForSelling();
        }
    }
}
