/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Point2D;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerList
implements Iterable<IAIPlayer> {
    @ListType(value=IAIPlayer.class)
    private List<IAIPlayer> players = new ArrayList<IAIPlayer>();

    @Override
    public Iterator<IAIPlayer> iterator() {
        return this.players.iterator();
    }

    public boolean add(IAIPlayer player) {
        return this.players.add(player);
    }

    public List<IAIPlayer> getAll() {
        return this.players;
    }

    public List<IAIPlayer> findAIPlayersCurrentlyInCity(ICity city) {
        ArrayList<IAIPlayer> players = new ArrayList<IAIPlayer>();
        Point2D coordinates = city.getCoordinates();
        block0: for (IAIPlayer player : this.players) {
            if (player.findTradingOffice(city).isPresent()) {
                players.add(player);
                continue;
            }
            List<IShip> fleet = player.getFleet();
            for (IShip ship : fleet) {
                if (!ship.getLocation().equals((Object)coordinates)) continue;
                players.add(player);
                continue block0;
            }
        }
        return players;
    }
}

