/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class TradingOfficeList
implements Iterable<ITradingOffice> {
    @ListType(value=ITradingOffice.class)
    private List<ITradingOffice> offices = new ArrayList<ITradingOffice>();

    @Override
    public Iterator<ITradingOffice> iterator() {
        return this.offices.iterator();
    }

    public boolean add(ITradingOffice iTradingOffice) {
        return this.offices.add(iTradingOffice);
    }

    public List<ITradingOffice> findOwnedBy(IPlayer player) {
        return this.offices.stream().filter(office -> office.getOwner().equals(player)).collect(Collectors.toList());
    }
}

