/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.building.impl;

import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Steward
implements ISteward {
    private int expertiseLevel = 0;
    private int salary = 5;
    private int totalProfit = 0;

    @Override
    public int getTotalProfit() {
        return this.totalProfit;
    }

    @Override
    public void updateProfit(int profit) {
        this.totalProfit += profit;
    }

    @Override
    public void upgradeToNextLevel() {
        Preconditions.checkArgument((this.expertiseLevel < 5 ? 1 : 0) != 0, (Object)"Cannot exceed experiance level 5");
        ++this.expertiseLevel;
        this.salary = (int)(1.8 * (double)this.salary);
    }

    @Override
    public int getExpertiseLevel() {
        return this.expertiseLevel;
    }

    @Override
    public int getSalary() {
        return this.salary;
    }
}

