/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.product.AmountablePriceDouble;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.HashMap;
import java.util.Map;

@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Prototype
public class ProductionStorage {
    @MapType(key=IWare.class, value=Double.class)
    private Map<IWare, AmountablePriceDouble> storage = new HashMap<IWare, AmountablePriceDouble>();

    public double getStored(IWare ware) {
        if (this.storage.containsKey(ware)) {
            return this.storage.get(ware).getAmount();
        }
        return 0.0;
    }

    public double getAvgPrice(IWare ware) {
        if (this.storage.containsKey(ware)) {
            return this.storage.get(ware).getAVGPrice();
        }
        return 0.0;
    }

    public double transfer(IWare ware, double amount, double avgPrice) {
        AmountablePriceDouble amountablePrice;
        double stored = 0.0;
        if (this.storage.containsKey(ware)) {
            amountablePrice = this.storage.get(ware);
            stored = amountablePrice.getAmount();
        } else {
            amountablePrice = new AmountablePriceDouble();
            this.storage.put(ware, amountablePrice);
        }
        if (amount < 0.0) {
            amountablePrice.remove(-amount);
        } else {
            amountablePrice.add(amount, avgPrice);
        }
        double storedAfter = amountablePrice.getAmount();
        return storedAfter - stored;
    }
}

