/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class GuildList
implements Iterable<IGuild> {
    @ListType(value=IGuild.class)
    private List<IGuild> guilds = new ArrayList<IGuild>();

    @Override
    public Iterator<IGuild> iterator() {
        return this.guilds.iterator();
    }

    public int size() {
        return this.guilds.size();
    }

    public boolean isEmpty() {
        return this.guilds.isEmpty();
    }

    public IGuild get(int index) {
        return this.guilds.get(index);
    }

    public boolean add(IGuild guild) {
        return this.guilds.add(guild);
    }

    public Optional<IGuild> findGuild(ICity city) {
        for (IGuild guild : this.guilds) {
            if (!guild.getCity().equals(city)) continue;
            return Optional.of(guild);
        }
        return Optional.empty();
    }
}

