/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class GuildSettings {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(GuildSettings.class);
    @DependentValue(value="guild.entry.fee.min")
    private int minEntryFee = 15000;
    @DependentValue(value="guild.entry.fee.max")
    private int maxEntryFee = 65000;
    @Autowired
    private IMediterreanMap mediterreanMap;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;

    @PostConstruct
    private void initialisation() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to initialize DependentValue annotated fields");
        }
    }

    public int getMinEntryFee() {
        return this.minEntryFee;
    }

    public int getMaxEntryFee() {
        return this.maxEntryFee;
    }

    public IMediterreanMap getMediterreanMap() {
        return this.mediterreanMap;
    }
}

