/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.EBidLevel;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.utilities.CancelableRunnable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.MODEL, EClassCategory.SERIALIZABLE_BEAN})
public abstract class AbstractAuction
implements IAuction {
    private LocalDateTime auctionDate;
    private final int startingBid;
    @OptionalType(value=IPlayer.class)
    private final Optional<IPlayer> owner;
    private EBidLevel bidLevel;
    private IPlayer biddingPlayer;
    private int currentBid;
    @ListType(value=IAIPlayer.class)
    private List<IAIPlayer> biddingPlayers;
    @XStreamOmitField
    private CancelableRunnable currentTask;

    public AbstractAuction(LocalDateTime auctionDate, int startingBid) {
        this.auctionDate = auctionDate;
        this.startingBid = startingBid;
        this.owner = Optional.empty();
    }

    public AbstractAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner) {
        this.auctionDate = auctionDate;
        this.startingBid = startingBid;
        this.owner = Optional.of(owner);
    }

    @Override
    public LocalDateTime getAuctionDate() {
        return this.auctionDate;
    }

    @Override
    public void setAuctionDate(LocalDateTime auctionDate) {
        this.auctionDate = auctionDate;
    }

    @Override
    public int getStartingBid() {
        return this.startingBid;
    }

    @Override
    public Optional<IPlayer> getOwner() {
        return this.owner;
    }

    @Override
    public EBidLevel getBidLevel() {
        return this.bidLevel;
    }

    @Override
    public void setBidLevel(EBidLevel bidLevel) {
        this.bidLevel = bidLevel;
    }

    @Override
    public IPlayer getBiddingPlayer() {
        return this.biddingPlayer;
    }

    @Override
    public void setBiddingPlayer(IPlayer biddingPlayer) {
        this.biddingPlayer = biddingPlayer;
    }

    @Override
    public int getCurrentBid() {
        return this.currentBid;
    }

    @Override
    public void setCurrentBid(int currentBid) {
        this.currentBid = currentBid;
    }

    @Override
    public List<IAIPlayer> getBiddingPlayers() {
        return this.biddingPlayers;
    }

    @Override
    public void setBiddingPlayers(List<IAIPlayer> biddingPlayers) {
        this.biddingPlayers = biddingPlayers;
    }

    @Override
    public CancelableRunnable getCurrentTask() {
        return this.currentTask;
    }

    @Override
    public void setCurrentTask(CancelableRunnable currentTask) {
        this.currentTask = currentTask;
    }
}

