/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.NonNull;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class Debt
implements IDebt {
    private final ICitizen debitor;
    private final ICreditor creditor;
    @NonNull
    private final LocalDateTime dueDate;
    private final double interest;
    private final int amount;
    @NonNull
    private final LocalDateTime loanTakeOut;

    @Override
    public long getLoanedDuration(LocalDateTime now) {
        Duration duration = Duration.between(this.loanTakeOut, now);
        return duration.toDays() + 1L;
    }

    @Override
    public long getTotalDuration() {
        Duration duration = Duration.between(this.loanTakeOut, this.dueDate);
        return duration.toDays() + 1L;
    }

    public String toString() {
        return "Debt{debitor=" + this.debitor.getName() + " " + this.debitor.getLastName() + ", dueDate=" + this.dueDate + ", interest=" + this.interest + ", amount=" + this.amount + ", loanTakeOut=" + this.loanTakeOut + "}";
    }

    public static DebtBuilder builder() {
        return new DebtBuilder();
    }

    public Debt(ICitizen debitor, ICreditor creditor, @NonNull LocalDateTime dueDate, double interest, int amount, @NonNull LocalDateTime loanTakeOut) {
        if (dueDate == null) {
            throw new NullPointerException("dueDate is marked @NonNull but is null");
        }
        if (loanTakeOut == null) {
            throw new NullPointerException("loanTakeOut is marked @NonNull but is null");
        }
        this.debitor = debitor;
        this.creditor = creditor;
        this.dueDate = dueDate;
        this.interest = interest;
        this.amount = amount;
        this.loanTakeOut = loanTakeOut;
    }

    @Override
    public ICitizen getDebitor() {
        return this.debitor;
    }

    @Override
    public ICreditor getCreditor() {
        return this.creditor;
    }

    @Override
    @NonNull
    public LocalDateTime getDueDate() {
        return this.dueDate;
    }

    @Override
    public double getInterest() {
        return this.interest;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public static class DebtBuilder {
        private ICitizen debitor;
        private ICreditor creditor;
        private LocalDateTime dueDate;
        private double interest;
        private int amount;
        private LocalDateTime loanTakeOut;

        DebtBuilder() {
        }

        public DebtBuilder debitor(ICitizen debitor) {
            this.debitor = debitor;
            return this;
        }

        public DebtBuilder creditor(ICreditor creditor) {
            this.creditor = creditor;
            return this;
        }

        public DebtBuilder dueDate(LocalDateTime dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public DebtBuilder interest(double interest) {
            this.interest = interest;
            return this;
        }

        public DebtBuilder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public DebtBuilder loanTakeOut(LocalDateTime loanTakeOut) {
            this.loanTakeOut = loanTakeOut;
            return this;
        }

        public Debt build() {
            return new Debt(this.debitor, this.creditor, this.dueDate, this.interest, this.amount, this.loanTakeOut);
        }

        public String toString() {
            return "Debt.DebtBuilder(debitor=" + this.debitor + ", creditor=" + this.creditor + ", dueDate=" + this.dueDate + ", interest=" + this.interest + ", amount=" + this.amount + ", loanTakeOut=" + this.loanTakeOut + ")";
        }
    }
}

