/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.CityProperties;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanRequest;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class LoanerState
implements ILoaner {
    private final ICity city;
    @ListType(value=IDebt.class)
    private List<IDebt> debts = new ArrayList<IDebt>();
    @ListType(value=ILoanRequest.class)
    private List<ILoanRequest> requests = new ArrayList<ILoanRequest>();
    @ListType(value=ILoanProposal.class)
    private List<ILoanProposal> loanProposals = new ArrayList<ILoanProposal>();
    @Autowired
    private Date date;
    @Autowired
    private CityProperties cityProperties;

    public LoanerState(ICity city) {
        this.city = city;
    }

    @Override
    public void add(LoanProposal proposal) {
        this.loanProposals.add(proposal);
    }

    @Override
    public void add(LoanRequest request) {
        this.requests.add(request);
    }

    @Override
    public void clearOldRequests() {
        LocalDateTime now = this.date.getCurrentDate();
        LocalDateTime before4Weeks = now.minusWeeks(this.cityProperties.getLoaner().getMaxAgeRequest());
        this.requests.removeIf(request -> request.issued().isBefore(before4Weeks));
    }

    @Override
    public void addDebt(IDebt debt) {
        LocalDateTime now = this.date.getCurrentDate();
        Preconditions.checkArgument((boolean)debt.getDueDate().isAfter(now));
        this.debts.add(debt);
    }

    @Override
    public ICity getCity() {
        return this.city;
    }

    @Override
    public List<IDebt> getDebts() {
        return this.debts;
    }

    @Override
    public List<ILoanRequest> getRequests() {
        return this.requests;
    }

    @Override
    public List<ILoanProposal> getLoanProposals() {
        return this.loanProposals;
    }
}

