/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.ArrayList;
import java.util.List;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PopulationUpdateStats {
    private int nbHiredSailors = 0;
    private boolean feedThePoor = false;
    private int hiredWorkers = 0;
    @ListType(value=INavigableVessel.class)
    private List<INavigableVessel> arrivedShips = new ArrayList<INavigableVessel>();
    @ListType(value=INavigableVessel.class)
    private List<INavigableVessel> departedShips = new ArrayList<INavigableVessel>();

    public void reset() {
        this.nbHiredSailors = 0;
        this.feedThePoor = false;
        this.hiredWorkers = 0;
        this.arrivedShips.removeAll(this.departedShips);
        this.departedShips.clear();
    }

    public void hireSailors(int nbSailors) {
        this.nbHiredSailors += nbSailors;
    }

    public void feedingThePoor() {
        this.feedThePoor = true;
    }

    public void hiredInWorkshop(int nbWorkers) {
        this.hiredWorkers += nbWorkers;
    }

    public void arrives(INavigableVessel vessel) {
        this.arrivedShips.add(vessel);
    }

    public void depart(INavigableVessel vessel) {
        this.departedShips.add(vessel);
    }

    public int getNbHiredSailors() {
        return this.nbHiredSailors;
    }

    public boolean isFeedThePoor() {
        return this.feedThePoor;
    }

    public int getHiredWorkers() {
        return this.hiredWorkers;
    }

    public List<INavigableVessel> getArrivedShips() {
        return this.arrivedShips;
    }

    public List<INavigableVessel> getDepartedShips() {
        return this.departedShips;
    }
}

