/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.ShipyardProperties;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapOptionalValueType;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ShipyardState
implements IShipyard {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(ShipyardState.class);
    @DependentValue(value="shipyard.build.time.snaikka")
    private int buildTimeSnaikka;
    @DependentValue(value="shipyard.build.time.crayer")
    private int buildTimeCrayer;
    @DependentValue(value="shipyard.build.time.cog")
    private int buildTimeCog;
    @DependentValue(value="shipyard.build.time.holk")
    private int buildTimeHolk;
    @DependentValue(value="shipyard.repair.time.snaikka")
    private int repairTimeSnaikka;
    @DependentValue(value="shipyard.repair.time.crayer")
    private int repairTimeCrayer;
    @DependentValue(value="shipyard.repair.time.cog")
    private int repairTimeCog;
    @DependentValue(value="shipyard.repair.time.holk")
    private int repairTimeHolk;
    @MapOptionalValueType(key=IShipDueDate.class, value=TimedTask.class)
    private final Map<IShipDueDate, Optional<TimedTask>> repairList = Maps.newConcurrentMap();
    @MapOptionalValueType(key=IShipDueDate.class, value=TimedTask.class)
    private final Map<IShipDueDate, Optional<TimedTask>> buildList = Maps.newConcurrentMap();
    @MapOptionalValueType(key=IShipDueDate.class, value=TimedTask.class)
    private final Map<IShipDueDate, Optional<TimedTask>> refitList = Maps.newConcurrentMap();
    private double experience;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    private final ICity city;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @Autowired
    private ShipyardProperties shipyardProperties;

    public ShipyardState(ICity city) {
        this.city = city;
    }

    @PostConstruct
    public void initializeExperience() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to initialize DependentValue annotated fields");
        }
        int mapWidth = (int)this.map.getDimension().getWidth();
        double eastFactor = this.city.getCoordinates().getX() / (double)mapWidth / 0.5;
        double startYearPart = Math.max((this.date.getStartYear() - 1430) / 100, 0);
        this.experience = Math.max(startYearPart - eastFactor, 0.0);
        Preconditions.checkArgument((this.experience >= 0.0 ? 1 : 0) != 0, (Object)"Experiance must be positive");
    }

    @Override
    public List<IShipDueDate> getShipBuildingList() {
        return ImmutableList.copyOf(this.buildList.keySet());
    }

    @Override
    public List<IShipDueDate> getShipUpgradeList() {
        return ImmutableList.copyOf(this.refitList.keySet());
    }

    @Override
    public void addShipBuildingOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.buildList.put(dueDate, task);
    }

    @Override
    public void cancelShipBuildingOrder(LocalDateTime finish) {
        Iterator<IShipDueDate> iterator = this.buildList.keySet().iterator();
        while (iterator.hasNext()) {
            IShipDueDate dueDate = iterator.next();
            if (!dueDate.getDueDate().equals(finish)) continue;
            Optional<TimedTask> task = this.buildList.get(dueDate);
            task.ifPresent(timedTask -> this.taskList.remove((TimedTask)timedTask));
            iterator.remove();
            break;
        }
    }

    @Override
    public List<IShipDueDate> getShipRepairList() {
        return ImmutableList.copyOf(this.repairList.keySet());
    }

    @Override
    public void addShipRepairOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.repairList.put(dueDate, task);
        this.experience = Math.max(this.experience + 0.005, 1.0);
    }

    @Override
    public int calculateRepairMaterialCosts(IShip ship, int damage) {
        double shipSize = this.getShipSize(ship);
        return (int)((double)(damage * 10) * shipSize * (double)this.shipyardProperties.getMaterialCostPerUnit());
    }

    private double getShipSize(IShip ship) {
        double shipSize = 0.0;
        switch (ship.getShipType()) {
            case SNAIKKA: {
                shipSize = 1.0;
                break;
            }
            case CRAYER: {
                shipSize = 1.5;
                break;
            }
            case COG: {
                shipSize = 2.5;
                break;
            }
            case HOLK: {
                shipSize = 5.0;
            }
        }
        return shipSize;
    }

    @Override
    public int calculateRepairCosts(int repairTime, int materialCosts) {
        return repairTime * this.calculateSaleryPerDay() + materialCosts;
    }

    private int calculateSaleryPerDay() {
        return (int)((double)this.shipyardProperties.getSalaryPerDay() * (1.0 + this.experience * 10.0));
    }

    @Override
    public void cancelRepair(IShip ship) {
        Iterator<IShipDueDate> iterator = this.repairList.keySet().iterator();
        while (iterator.hasNext()) {
            IShipDueDate dueDate = iterator.next();
            if (!dueDate.getShip().equals(ship)) continue;
            Optional<TimedTask> task = this.repairList.get(dueDate);
            task.ifPresent(timedTask -> this.taskList.remove((TimedTask)timedTask));
            iterator.remove();
            ship.setAvailable(true);
            break;
        }
    }

    @Override
    public void addShipRefitOrder(IShipDueDate dueDate, Optional<TimedTask> task) {
        this.refitList.put(dueDate, task);
    }

    @Override
    public int calculateRefitTime(EShipType type) {
        return (int)Math.ceil((double)this.calculateBuildTime(type) / 10.0);
    }

    @Override
    public LocalDateTime getBuildCompleteDate(EShipType type) {
        LocalDateTime lastOrderFinished = this.date.getCurrentDate();
        for (IShipDueDate dueDate : this.buildList.keySet()) {
            if (!dueDate.getDueDate().isAfter(lastOrderFinished)) continue;
            lastOrderFinished = dueDate.getDueDate();
        }
        int buildTime = this.calculateBuildTime(type);
        return lastOrderFinished.plusDays(buildTime);
    }

    @Override
    public int calculateBuildTime(EShipType type) {
        int baseBuildTime = this.getBaseRepairTime(type);
        return (int)Math.rint((double)baseBuildTime + (1.0 - this.experience) * (double)baseBuildTime);
    }

    @Override
    public int calculateRepairTime(EShipType type) {
        int baseRepairTime = this.getBaseRepairTime(type);
        return (int)Math.rint((double)baseRepairTime + (1.0 - this.experience) * (double)baseRepairTime);
    }

    private int getBaseRepairTime(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return this.repairTimeSnaikka;
            }
            case CRAYER: {
                return this.repairTimeCrayer;
            }
            case COG: {
                return this.repairTimeCog;
            }
            case HOLK: {
                return this.repairTimeHolk;
            }
        }
        return 0;
    }

    @Override
    public int calculateRefitCosts(EShipType type, int levels) {
        return this.calculateRefitTime(type) * levels * this.calculateSaleryPerDay();
    }

    @Override
    public int calculateConstructionCosts(EShipType type) {
        return this.calculateBuildTime(type) * this.calculateSaleryPerDay();
    }

    @Override
    public EShipType[] getBuildableShipTypes() {
        if (this.date.getCurrentDate().getYear() > 1450 && this.experience > 0.4) {
            return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER, EShipType.COG, EShipType.HOLK};
        }
        if (this.date.getCurrentDate().getYear() > 1420 && this.experience > 0.2) {
            return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER, EShipType.COG};
        }
        return new EShipType[]{EShipType.SNAIKKA, EShipType.CRAYER};
    }

    @Override
    public void removeCompletedRepair(IShip ship) {
        this.removeEntry(ship, this.repairList);
    }

    private void removeEntry(IShip ship, Map<IShipDueDate, Optional<TimedTask>> list) {
        Iterator<Map.Entry<IShipDueDate, Optional<TimedTask>>> iterator = list.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IShipDueDate, Optional<TimedTask>> next = iterator.next();
            if (!next.getKey().getShip().equals(ship)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void removeCompletedConstruction(IShip ship) {
        this.removeEntry(ship, this.buildList);
    }

    @Override
    public void removeCompletedUpgrade(IShip ship) {
        this.removeEntry(ship, this.refitList);
    }

    @Override
    public ICity getCity() {
        return this.city;
    }
}

