/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

@ClassCategory(value={EClassCategory.EVENT_OBJECT})
public final class BuildingFinished
implements IEventMetaDataProvider {
    private final IBuilding building;
    private final IPlayer owner;
    private final ICity city;
    private final String className;
    private final String methodName;

    public BuildingFinished(IBuilding building, IPlayer owner, ICity city) {
        this.building = building;
        this.owner = owner;
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public IBuilding getBuilding() {
        return this.building;
    }

    public IPlayer getOwner() {
        return this.owner;
    }

    public ICity getCity() {
        return this.city;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildingFinished)) {
            return false;
        }
        BuildingFinished other = (BuildingFinished)o;
        IBuilding this$building = this.getBuilding();
        IBuilding other$building = other.getBuilding();
        if (this$building == null ? other$building != null : !this$building.equals(other$building)) {
            return false;
        }
        IPlayer this$owner = this.getOwner();
        IPlayer other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        ICity this$city = this.getCity();
        ICity other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IBuilding $building = this.getBuilding();
        result = result * 59 + ($building == null ? 43 : $building.hashCode());
        IPlayer $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        ICity $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        return result;
    }

    public String toString() {
        return "BuildingFinished(building=" + this.getBuilding() + ", owner=" + this.getOwner() + ", city=" + this.getCity() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ")";
    }
}

