/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;

@ClassCategory(value={EClassCategory.EVENT_OBJECT})
public class TargetedEvent
implements IEventMetaDataProvider {
    private final IHumanPlayer player;
    private final Object event;
    private String className;
    private String methodName;
    @ListType(value=EventBus.class)
    private List<EventBus> eventbusBlackList = new ArrayList<EventBus>();

    public TargetedEvent(IHumanPlayer player, Object event) {
        this.player = player;
        this.event = event;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public TargetedEvent(IHumanPlayer player, Object event, List<EventBus> eventbusBlackList) {
        this(player, event);
        this.eventbusBlackList = eventbusBlackList;
    }

    public void addToBlackList(EventBus blacklisted) {
        this.eventbusBlackList.add(blacklisted);
    }

    public IHumanPlayer getPlayer() {
        return this.player;
    }

    public Object getEvent() {
        return this.event;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<EventBus> getEventbusBlackList() {
        return this.eventbusBlackList;
    }
}

