/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class TimedUpdatableTaskList {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EVENTS");
    @XStreamOmitField
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="timerEventBus")
    @XStreamOmitField
    private AsyncEventBus timerEventBus;
    @ListType(value=TimedTask.class)
    private final List<TimedTask> tasks = new ArrayList<TimedTask>();

    @PostConstruct
    public void registerWithClock() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimedTask task) {
        List<TimedTask> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
            LOGGER.info("Add task {}:{}", (Object)task.getClass().getName(), (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimedTask task) {
        List<TimedTask> list = this.tasks;
        synchronized (list) {
            this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handleClockTick(ClockTick event) {
        LocalDateTime now = this.date.getCurrentDate();
        List<TimedTask> list = this.tasks;
        synchronized (list) {
            ArrayList<TimedTask> unmodifieablyCopy = new ArrayList<TimedTask>(this.tasks);
            unmodifieablyCopy.stream().filter(task -> task.getExecutionTime().isBefore(now)).forEach(task -> {
                try {
                    this.tasks.remove(task);
                    task.run();
                    LOGGER.info("Executed task {}:{}", (Object)task.getClass().getName(), task);
                }
                catch (Exception e) {
                    this.log.error("Failed to execute timed task", (Throwable)e);
                }
            });
        }
    }

    TimedTask getFirst() {
        return this.tasks.get(0);
    }
}

