/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeaponsDealerState
implements IWeaponsDealer {
    @XStreamOmitField
    private static final Logger LOGGER = LoggerFactory.getLogger(WeaponsDealerState.class);
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @DependentValue(value="tavern.weapons.dealer.sellvalue.factor")
    private double sellValue;
    @Autowired
    private ArmoryRegistry armoryRegistry;
    private IArmory armory;

    @PostConstruct
    public void init() {
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to initialize DependentValue annotated fields");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int move(IWeapon weapon, int amount) {
        IWeapon iWeapon = weapon;
        synchronized (iWeapon) {
            int amounted = this.getWeapon(weapon);
            if (amount < 0 && this.containsWeapon(weapon) && -amount > amounted) {
                amount = -amounted;
            }
            if (amount < 0 && !this.containsWeapon(weapon)) {
                amount = 0;
            }
            switch ((EWeapon)weapon) {
                case BALLISTA_SMALL: {
                    this.armory.updateBallistaSmallAmount(amount);
                    break;
                }
                case HAND_WEAPON: {
                    this.armory.updateCutlassAmount(amount);
                    break;
                }
                case TREBUCHET_SMALL: {
                    this.armory.updateTrebuchetSmallAmount(amount);
                    break;
                }
                case CANNON: {
                    this.armory.updateCanonAmount(amount);
                    break;
                }
                case BALLISTA_BIG: {
                    this.armory.updateBallistaBigAmount(amount);
                    break;
                }
                case TREBUCHET_BIG: {
                    this.armory.updateTrebuchetSmallAmount(amount);
                    break;
                }
                case BOMBARD: {
                    this.armory.updateBombardAmount(amount);
                    break;
                }
                case SWORD: {
                    this.armory.updateSwordAmount(amount);
                    break;
                }
                case BOW: {
                    this.armory.updateBowAmount(amount);
                    break;
                }
                case CROSSBOW: {
                    this.armory.updateCrossbowAmount(amount);
                    break;
                }
                case MUSKET: {
                    this.armory.updateMusketAmount(amount);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled weapon " + weapon);
                }
            }
            return amount;
        }
    }

    protected final boolean containsWeapon(IWeapon weapons) {
        return this.getWeapon(weapons) > 0;
    }

    private int getWeapon(IWeapon weapon) {
        return this.amountAvailableProperty((EWeapon)weapon).get();
    }

    @Override
    public ReadOnlyIntegerProperty amountAvailableProperty(EWeapon weapon) {
        switch (weapon) {
            case BALLISTA_SMALL: {
                return this.armory.ballistaSmallAmountProperty();
            }
            case HAND_WEAPON: {
                return this.armory.cutlassAmountProperty();
            }
            case TREBUCHET_SMALL: {
                return this.armory.trebuchetSmallAmountProperty();
            }
            case CANNON: {
                return this.armory.canonAmountProperty();
            }
            case BALLISTA_BIG: {
                return this.armory.ballistaBigAmountProperty();
            }
            case TREBUCHET_BIG: {
                return this.armory.trebuchetBigAmountProperty();
            }
            case BOMBARD: {
                return this.armory.bombardAmountProperty();
            }
            case SWORD: {
                return this.armory.swordAmountProperty();
            }
            case BOW: {
                return this.armory.bowAmountProperty();
            }
            case CROSSBOW: {
                return this.armory.crossbowAmountProperty();
            }
            case MUSKET: {
                return this.armory.musketAmountProperty();
            }
        }
        throw new IllegalArgumentException("Unhandled weapon " + weapon);
    }

    @Override
    public void setCity(ICity city) {
        this.armory = this.armoryRegistry.getArmory(city);
    }
}

