/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Reputation
implements IReputation {
    private int reputationLastWeek = 0;
    private int reputationCurrentWeek = 0;
    private final ICity city;
    private final IPlayer player;

    public Reputation(ICity city, IPlayer player) {
        this.city = city;
        this.player = player;
    }

    @Override
    public int getReputationDifference() {
        return this.reputationCurrentWeek - this.reputationLastWeek;
    }

    @Override
    public void addWareReputation(int wareReputation) {
        this.reputationLastWeek = this.reputationCurrentWeek;
        this.reputationCurrentWeek += wareReputation;
    }

    @Override
    public int getPopularity() {
        return this.reputationCurrentWeek;
    }

    @Override
    public void update(int amount) {
        this.reputationCurrentWeek += amount;
    }
}

