/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.BaseAmountable;
import ch.sahits.game.openpatrician.model.IAmountable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AmountablePrice<T extends IAmountable>
extends BaseAmountable<T> {
    private final DoubleProperty sum = new SimpleDoubleProperty((Object)this, "sum", 0.0);

    public AmountablePrice() {
    }

    public AmountablePrice(int amount, double totalPrice) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0, (Object)"Amount may not be negative");
        Preconditions.checkArgument((totalPrice >= 0.0 ? 1 : 0) != 0, (Object)"Total price may not be negative");
        this.setAmount(amount);
        this.sum.setValue((Number)totalPrice);
    }

    public int getAVGPrice() {
        return (int)Math.rint(this.sum.doubleValue() / (double)this.getAmount());
    }

    public NumberBinding avgPriceProperty() {
        return new IntegerBinding(){

            protected int computeValue() {
                return AmountablePrice.this.getAVGPrice();
            }
        };
    }

    public void add(int amount, int avgPrice) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0, (Object)("Amount may not be negative: " + amount));
        Preconditions.checkArgument((avgPrice >= 0 ? 1 : 0) != 0, (Object)("Average price may not be negative: " + avgPrice));
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            int current = this.getAmount();
            this.setAmount(current + localAmount);
            long sum = this.sum.longValue();
            this.sum.set((double)(sum + (long)(localAmount * avgPrice)));
        });
    }

    @Override
    public void remove(int amount) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0, (Object)("Amount may not be negative: " + amount));
        this.fxTheadExecution.execute(() -> {
            int localAmount = amount;
            if (localAmount < 0) {
                localAmount = Math.abs(localAmount);
            }
            if (localAmount == Integer.MIN_VALUE) {
                localAmount = Integer.MAX_VALUE;
            }
            if (this.getAmount() < localAmount) {
                this.setAmount(0);
                this.sum.set(0.0);
            } else {
                long sum = this.sum.longValue();
                this.sum.set((double)(sum - (long)(localAmount * this.getAVGPrice())));
                int current = this.getAmount();
                this.setAmount(current - localAmount);
            }
            if (this.getAmount() == 0) {
                this.sum.set(0.0);
            }
        });
    }

    @Override
    public void reset() {
        this.fxTheadExecution.execute(() -> {
            this.sum.set(0.0);
            super.reset();
        });
    }

    @Override
    public String toString() {
        return this.getAmount() + "@" + this.getAVGPrice();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AmountablePrice that = (AmountablePrice)o;
        return this.sum != null ? this.sum.get() == that.sum.get() : that.sum == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sum != null ? this.sum.hashCode() : 0);
        return result;
    }

    public double getSum() {
        return this.sum.get();
    }
}

