/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.base.Preconditions;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

@ClassCategory(value={EClassCategory.MODEL})
public class AmountablePriceDouble {
    private final DoubleProperty amount = new SimpleDoubleProperty(0.0);
    private final DoubleProperty sum = new SimpleDoubleProperty(0.0);

    public double getAmount() {
        return this.amount.get();
    }

    public int getAVGPrice() {
        return (int)Math.rint(this.sum.doubleValue() / this.getAmount());
    }

    public double getAVGPriceExact() {
        return this.sum.doubleValue() / this.getAmount();
    }

    public void add(double amount, double avgPrice) {
        Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (Object)("Amount may not be negative: " + amount));
        Preconditions.checkArgument((avgPrice >= 0.0 ? 1 : 0) != 0, (Object)("Average price may not be negative: " + avgPrice));
        double localAmount = amount;
        if (localAmount < 0.0) {
            localAmount = Math.abs(localAmount);
        }
        double current = this.getAmount();
        this.amount.setValue((Number)(current + localAmount));
        long sum = this.sum.longValue();
        this.sum.set((double)sum + localAmount * avgPrice);
    }

    public void remove(double amount) {
        Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (Object)("Amount may not be negative: " + amount));
        double localAmount = amount;
        if (localAmount < 0.0) {
            localAmount = Math.abs(localAmount);
        }
        if (localAmount == Double.MIN_VALUE) {
            localAmount = Double.MAX_VALUE;
        }
        if (this.getAmount() < localAmount) {
            this.amount.setValue((Number)0);
            this.sum.set(0.0);
        } else {
            double sum = this.sum.doubleValue();
            this.sum.set(sum - localAmount * this.getAVGPriceExact());
            double current = this.getAmount();
            this.amount.setValue((Number)(current - localAmount));
        }
        if (this.getAmount() == 0.0) {
            this.sum.set(0.0);
        }
    }
}

