/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;
import ch.sahits.game.openpatrician.model.product.BasePriceCalulation;
import ch.sahits.game.openpatrician.model.product.IPriceCalculation;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
class SimplePriceCalculation
extends BasePriceCalulation
implements IPriceCalculation {
    SimplePriceCalculation() {
    }

    @Override
    public double computePrice(int min, int max, int available, int saturation, int productionRate, IPopulationStructure pop, ECityState state) {
        System.out.println("Calculate price with min=" + min + ", max=" + max + ", available=" + available + ", saturation=" + saturation);
        if (available == 0) {
            return max;
        }
        if (available >= saturation) {
            return min;
        }
        double val = Math.cos((double)available * Math.PI / (double)saturation);
        val += 1.0;
        val *= 0.5;
        val *= (double)(max - min);
        return val += (double)min;
    }

    @Override
    public int computePrice(ITradable tradable, boolean buy, int available, int productionRate, IPopulationStructure pop, ECityState state) {
        int min = this.getMinValue(tradable, buy);
        int max = this.getMaxValue(tradable, buy);
        int saturation = this.getSaturation(tradable, buy);
        return (int)this.computePrice(min, max, available, saturation, productionRate, pop, state);
    }
}

