/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service;

import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.beans.property.ObjectProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TransferUtil {
    public int calculateAvailableAmount(ObjectProperty<ETransferAmount> movableAmount, int maxAmount) {
        return this.calculateAvailableAmount((ETransferAmount)((Object)movableAmount.get()), maxAmount);
    }

    public int calculateAvailableAmount(ETransferAmount movableAmount, int maxAmount) {
        switch (movableAmount) {
            case ONE: {
                return Math.min(maxAmount, 1);
            }
            case FIVE: {
                if (maxAmount < 5) {
                    return maxAmount;
                }
                return 5;
            }
            case MAX: {
                return maxAmount;
            }
        }
        throw new RuntimeException("Not reachable statement");
    }
}

