/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.AmountableProvider;
import ch.sahits.game.openpatrician.model.javafx.bindings.LateIntegerBinding;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipTravelState;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipAutoTrading;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.ShipProperties;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.utilities.service.LUIDProvider;
import ch.sahits.game.openpatrician.utilities.spring.DependentPropertyInitializer;
import ch.sahits.game.openpatrician.utilities.spring.DependentValue;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public abstract class Ship
implements IShip {
    @XStreamOmitField
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @DependentValue(value="sailor.space.on.ship")
    private double spacePerSailor = 0.5;
    @DependentValue(value="passenger.space.on.ship")
    private int passengerSpace = 2;
    private int distanceInKmForOneHealthPointReduction;
    @Autowired
    private LUIDProvider luidProvider;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    protected EShipUpgrade shipUpgradeLevel;
    protected String name;
    @MapType(key=IWare.class, value=AmountablePrice.class)
    private Map<IWare, AmountablePrice<IWare>> loadedWare = new NonReplacableMap();
    @ObjectPropertyType(value=IShip.class)
    private ObjectProperty<IShip> parentShip = new SimpleObjectProperty(null);
    @XStreamOmitField
    private LateIntegerBinding loadBinding = this.createLoadBinding();
    private double topSpeed;
    @Autowired
    @XStreamOmitField
    private AmountableProvider amountableProvider;
    @Autowired
    @XStreamOmitField
    private DependentPropertyInitializer propertyInitializer;
    @XStreamOmitField
    private BooleanBinding passengerPresent = new BooleanBinding(){

        protected boolean computeValue() {
            return Ship.this.passenger.isPresent();
        }
    };
    private int loadedHandWeapons = 0;
    private List<IWeaponSlot> weaponSlots = new ArrayList<IWeaponSlot>();
    private int initialValue;
    private int minNumberOfSailors;
    private int maxSailors;
    @OptionalType(value=ICaptain.class)
    private Optional<ICaptain> captian = Optional.empty();
    @OptionalType(value=IPerson.class)
    private Optional<IPerson> passenger = Optional.empty();
    @OptionalType(value=IShipAutoTrading.class)
    private Optional<IShipAutoTrading> autotrading = Optional.empty();
    private int fitness = 100;
    private IntegerProperty nbSailors = new SimpleIntegerProperty(0);
    private Point2D location = null;
    private IShipOwner owner = null;
    private boolean available = true;
    private int occupiedSpace;
    private int size;
    private int reductionLevel1;
    private int reductionLevel2;
    private String uuid;
    private BooleanProperty pirateFlag = new SimpleBooleanProperty(false);
    @ObjectPropertyType(value=EShipTravelState.class)
    private ObjectProperty<EShipTravelState> travelState = new SimpleObjectProperty((Object)EShipTravelState.ANCHOR);

    protected final void initializeProperties(ShipProperties.Ship shipConfiguration) {
        this.initialValue = shipConfiguration.getInitialValue();
        this.minNumberOfSailors = shipConfiguration.getMinNumberOfSailors();
        this.maxSailors = shipConfiguration.getMaxSailors();
        this.size = shipConfiguration.getSize();
        this.reductionLevel1 = shipConfiguration.getReductionLevel1();
        this.reductionLevel2 = shipConfiguration.getReductionLevel2();
        this.topSpeed = shipConfiguration.getSpeedkmperh();
        this.distanceInKmForOneHealthPointReduction = shipConfiguration.getDistanceInKmForOneHealthPointReduction();
    }

    @PostConstruct
    private void init() {
        if (this.uuid == null) {
            this.uuid = this.luidProvider.getNextLUID();
        }
        try {
            this.propertyInitializer.initializeAnnotatedFields((Object)this);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to initialize DependentValue annotated fields");
        }
    }

    @Override
    public int getMaxNumberOfSailors() {
        int availableSpace = this.getCapacity();
        int spaceForSailors = (int)Math.rint((double)availableSpace / this.spacePerSailor);
        return Math.min(this.maxSailors, spaceForSailors);
    }

    @Override
    public void setCaptain(ICaptain captain) {
        this.captian = Optional.ofNullable(captain);
    }

    @Override
    public boolean isUpgradable() {
        return this.shipUpgradeLevel != EShipUpgrade.LEVEL2;
    }

    @Override
    public void upgrade() {
        EShipUpgrade[] levels = EShipUpgrade.values();
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] != this.shipUpgradeLevel) continue;
            this.shipUpgradeLevel = levels[i + 1];
            break;
        }
    }

    @Override
    public Set<IWare> getLoadedWares() {
        return this.loadedWare.keySet();
    }

    @Override
    public int load(IWare ware, int amount, int avgPrice) {
        short sizeInBarrels = ware.getSizeAsBarrels();
        int cap = this.ensureCapacity((amount = Math.abs(amount)) * sizeInBarrels);
        if (cap != amount && sizeInBarrels != 1) {
            cap = cap / sizeInBarrels * sizeInBarrels;
        }
        AmountablePrice<IWare> available = this.getWare(ware);
        available.add(cap / ware.getSizeAsBarrels(), avgPrice);
        return cap / sizeInBarrels;
    }

    private int ensureCapacity(int amount) {
        return Math.max(Math.min(amount, this.getCapacity()), 0);
    }

    @Override
    public int unload(IWare ware, int amount) {
        if (!this.loadedWare.containsKey(ware)) {
            return 0;
        }
        amount = Math.abs(amount);
        int loaded = this.loadedWare.get(ware).getAmount() * ware.getSizeAsBarrels();
        int unloaded = Math.min(loaded, amount *= ware.getSizeAsBarrels());
        if (unloaded == loaded) {
            AmountablePrice<IWare> available = this.loadedWare.get(ware);
            available.reset();
        } else {
            AmountablePrice<IWare> available = this.loadedWare.get(ware);
            available.remove(unloaded / ware.getSizeAsBarrels());
        }
        return unloaded / ware.getSizeAsBarrels();
    }

    private int internalLoadCalculation() {
        int sum = 0;
        for (Map.Entry<IWare, AmountablePrice<IWare>> entry : this.loadedWare.entrySet()) {
            int amount = entry.getValue().getAmount();
            short barrelSize = entry.getKey().getSizeAsBarrels();
            sum += amount * barrelSize;
        }
        return sum;
    }

    @Override
    public IntegerBinding getLoadBinding() {
        if (this.loadBinding == null) {
            this.loadBinding = this.createLoadBinding();
        }
        return this.loadBinding;
    }

    protected void clearLoadedWares() {
        for (AmountablePrice<IWare> amountable : this.loadedWare.values()) {
            amountable.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmountablePrice<IWare> getWare(IWare ware) {
        Map<IWare, AmountablePrice<IWare>> map = this.loadedWare;
        synchronized (map) {
            if (!this.loadedWare.containsKey(ware)) {
                AmountablePrice<IWare> amountable = this.amountableProvider.createWareAmountable();
                this.loadedWare.put(ware, amountable);
                ((LateIntegerBinding)this.getLoadBinding()).bind((Observable)amountable.amountProperty());
            }
        }
        return this.loadedWare.get(ware);
    }

    @Override
    public int getValue() {
        return (int)Math.rint((double)(this.initialValue * this.fitness) / 100.0);
    }

    @Override
    public int getCargoValue() {
        int sum = 0;
        for (AmountablePrice<IWare> amountablePrice : this.loadedWare.values()) {
            sum = (int)((double)sum + amountablePrice.getSum());
        }
        return sum;
    }

    @Override
    public int getNumberOfSailors() {
        return this.nbSailors.get();
    }

    @Override
    public void setNumberOfSailors(int nbSailors) {
        this.nbSailors.set(nbSailors);
    }

    @Override
    public IntegerProperty numberOfSailorsProperty() {
        return this.nbSailors;
    }

    @Override
    public int getWeaponAmount(IWeapon weaponType) {
        if (EWeapon.HAND_WEAPON == weaponType) {
            return this.loadedHandWeapons;
        }
        return (int)this.weaponSlots.stream().filter(slot -> slot.getWeapon().isPresent()).filter(slot -> slot.getWeapon().get() == weaponType).count();
    }

    @Override
    public void addPassenger(IPerson passanger) {
        Preconditions.checkArgument((!this.passenger.isPresent() ? 1 : 0) != 0, (Object)"Passenger already present");
        this.passenger = Optional.of(passanger);
        this.passengerPresent.invalidate();
    }

    @Override
    public IShipOwner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(IShipOwner owner) {
        Preconditions.checkNotNull((Object)owner, (Object)"Owner of a ship may not be null");
        if (this.owner != null) {
            this.logger.warn("Set owner of ship " + this.getName() + " of " + this.owner.getName() + " " + this.owner.getLastName() + " to " + owner.getName() + " " + owner.getLastName(), (Throwable)new Exception("Stacktrace"));
        }
        this.owner = owner;
    }

    @Override
    public void leavePassenger() {
        this.passenger = Optional.empty();
        this.passengerPresent.invalidate();
    }

    @Override
    public int getCapacity() {
        int passengerSpace = this.passenger.map(iPerson -> this.passengerSpace).orElse(0);
        return this.size - this.getUpgradeSpaceReduction() - this.internalLoadCalculation() - this.getOccupiedSpace() - passengerSpace - this.getOccupiedSpaceByWeapons();
    }

    @Override
    public int getUpgradeSpaceReduction() {
        switch (this.shipUpgradeLevel) {
            case NONE: {
                return 0;
            }
            case LEVEL1: {
                return this.reductionLevel1;
            }
            case LEVEL2: {
                return this.reductionLevel2;
            }
        }
        return 0;
    }

    private LateIntegerBinding createLoadBinding() {
        return new LateIntegerBinding(){

            protected int computeValue() {
                return Ship.this.internalLoadCalculation();
            }
        };
    }

    @Override
    public BooleanBinding passengerPresentProperty() {
        return this.passengerPresent;
    }

    @Override
    public int getDamage() {
        return 100 - this.fitness;
    }

    @Override
    public void damage(int damage, boolean destroyWeapon) {
        block3: {
            IWeaponSlot slot;
            boolean destroyAWeapon;
            Preconditions.checkArgument((damage > 0 ? 1 : 0) != 0, (Object)"The damage must be positive");
            this.fitness = Math.max(0, this.fitness - damage);
            boolean bl = destroyAWeapon = destroyWeapon && this.rnd.nextInt(this.fitness) < 50;
            if (!destroyAWeapon || !this.hasWeapons()) break block3;
            int slotIndex = this.rnd.nextInt(this.weaponSlots.size());
            while (!(slot = this.weaponSlots.get(slotIndex)).getWeapon().isPresent()) {
            }
            EWeapon weapon = (EWeapon)slot.getWeapon().get();
            slot.setWeapon(null);
            if (slot instanceof SecondaryLargeWeaponSlot && this.isLargeWeapon(weapon)) {
                this.weaponSlots.get(slotIndex - 1).setWeapon(null);
            }
            if (slot instanceof PrimaryLargeWeaponSlot && this.isLargeWeapon(weapon)) {
                this.weaponSlots.get(slotIndex + 1).setWeapon(null);
            }
        }
    }

    private boolean hasWeapons() {
        for (IWeaponSlot weaponSlot : this.weaponSlots) {
            if (!weaponSlot.getWeapon().isPresent()) continue;
            return true;
        }
        return false;
    }

    private boolean isLargeWeapon(EWeapon weapon) {
        switch (weapon) {
            case TREBUCHET_BIG: 
            case BALLISTA_BIG: 
            case BOMBARD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void repair() {
        this.fitness = 100;
    }

    @Override
    public int getLoadableSpace() {
        return this.getSize() - this.getUpgradeSpaceReduction();
    }

    @Override
    public double getTopSpeed() {
        return this.topSpeed;
    }

    @Override
    public boolean getPirateFlag() {
        return this.pirateFlag.get();
    }

    @Override
    public void togglePirateFlag() {
        this.pirateFlag.setValue(Boolean.valueOf(!this.pirateFlag.get()));
    }

    @Override
    public BooleanProperty pirateFlagProperty() {
        return this.pirateFlag;
    }

    @Override
    public double getCurrentSpeed() {
        if (this.getDamage() == 0) {
            return this.topSpeed;
        }
        return Math.max(0.5, this.topSpeed / (double)this.getDamage() / 100.0);
    }

    @Override
    public ObjectProperty<IShip> parentShipProperty() {
        return this.parentShip;
    }

    @Override
    public void updateHandweapon(int delta) {
        this.loadedHandWeapons += delta;
    }

    @Override
    public int getOccupiedSpaceByWeapons() {
        double sum = this.getWeaponSlots().stream().filter(slot -> slot.getWeapon().isPresent()).mapToDouble(slot -> slot.getWeapon().get().getSize()).sum();
        return (int)Math.rint(sum);
    }

    @Override
    public ObjectProperty<EShipTravelState> travelState() {
        return this.travelState;
    }

    @Override
    public void setTravelState(EShipTravelState state) {
        this.travelState.setValue((Object)state);
    }

    @Override
    public void setAutoTrading(IShipAutoTrading autoTrading) {
        this.autotrading = autoTrading == null ? Optional.empty() : Optional.of(autoTrading);
    }

    public String toString() {
        return this.getShipType() + " name=" + this.name + "(" + this.uuid + ") of " + this.owner;
    }

    @Override
    public int getDistanceInKmForOneHealthPointReduction() {
        return this.distanceInKmForOneHealthPointReduction;
    }

    @Override
    public EShipUpgrade getShipUpgradeLevel() {
        return this.shipUpgradeLevel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<IWeaponSlot> getWeaponSlots() {
        return this.weaponSlots;
    }

    @Override
    public void setWeaponSlots(List<IWeaponSlot> weaponSlots) {
        this.weaponSlots = weaponSlots;
    }

    @Override
    public int getMinNumberOfSailors() {
        return this.minNumberOfSailors;
    }

    @Override
    public Optional<ICaptain> getCaptian() {
        return this.captian;
    }

    @Override
    public Optional<IPerson> getPassenger() {
        return this.passenger;
    }

    @Override
    public Optional<IShipAutoTrading> getAutotrading() {
        return this.autotrading;
    }

    @Override
    public void setLocation(Point2D location) {
        this.location = location;
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public int getOccupiedSpace() {
        return this.occupiedSpace;
    }

    @Override
    public void setOccupiedSpace(int occupiedSpace) {
        this.occupiedSpace = occupiedSpace;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }
}

