/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.data.xmlmodel.weapon.BasicSlot;
import ch.sahits.game.openpatrician.data.xmlmodel.weapon.SlotType;
import ch.sahits.game.openpatrician.data.xmlmodel.weapon.WeaponLocations;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ESide;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SmallWeaponSlot;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipWeaponsLocationFactory {
    private static final Logger log = LoggerFactory.getLogger(ShipWeaponsLocationFactory.class);
    @Autowired
    @Qualifier(value="jaxb2XmlModelMarshallerWeapon")
    private Unmarshaller unmarshaller;
    private WeaponLocations weaponLocations;

    @PostConstruct
    private void initilizeWeaponModel() {
        try {
            Source sourceFromFile = this.getSourceFromFile("/weaponLocation.xml");
            this.weaponLocations = (WeaponLocations)this.unmarshaller.unmarshal(sourceFromFile);
        }
        catch (IOException e) {
            log.warn("Failed to initialize weapons location");
        }
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }

    public List<IWeaponSlot> getShipWeaponsLocation(EShipType type, EShipUpgrade level) {
        WeaponLocations.WeaponLocation weaponLocation = null;
        for (WeaponLocations.WeaponLocation location : this.weaponLocations.getWeaponLocation()) {
            if (!type.name().equals(location.getType().name()) || !this.checkLevel(level, location)) continue;
            weaponLocation = location;
            break;
        }
        return this.convert(weaponLocation);
    }

    private boolean checkLevel(EShipUpgrade level, WeaponLocations.WeaponLocation location) {
        switch (location.getLevel()) {
            case NONE: {
                return level.name().equals(location.getLevel().name());
            }
            case LEVEL_1: {
                return level.name().equals("LEVEL1");
            }
            case LEVEL_2: {
                return level.name().equals("LEVEL2");
            }
        }
        return false;
    }

    private List<IWeaponSlot> convert(WeaponLocations.WeaponLocation weaponLocation) {
        ArrayList<IWeaponSlot> weaponSlots = new ArrayList<IWeaponSlot>();
        for (BasicSlot next : weaponLocation.getSlot()) {
            IWeaponSlot slot = this.convert(next);
            weaponSlots.add(slot);
        }
        return weaponSlots;
    }

    private IWeaponSlot convert(BasicSlot slot) {
        if (slot.getType().equals((Object)SlotType.SMALL)) {
            SmallWeaponSlot small = new SmallWeaponSlot(ESide.valueOf(slot.getSide().name()), slot.getId());
            small.setOffset(new Point2D((double)slot.getX(), (double)slot.getY()));
            return small;
        }
        if (slot.getType().equals((Object)SlotType.PRIMARY)) {
            PrimaryLargeWeaponSlot primary = new PrimaryLargeWeaponSlot(ESide.valueOf(slot.getSide().name()), slot.getId());
            primary.setOffset(new Point2D((double)slot.getX(), (double)slot.getY()));
            return primary;
        }
        if (slot.getType().equals((Object)SlotType.SECONDARY)) {
            SecondaryLargeWeaponSlot secondary = new SecondaryLargeWeaponSlot(ESide.valueOf(slot.getSide().name()), slot.getId());
            secondary.setOffset(new Point2D((double)slot.getX(), (double)slot.getY()));
            return secondary;
        }
        throw new IllegalArgumentException("Unrecognized type " + slot.getClass());
    }
}

