/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ui;

import ch.sahits.game.openpatrician.model.ui.ButtonTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import java.util.Arrays;
import java.util.List;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class DialogTemplate {
    private final String titleKey;
    private final String messageKey;
    private final Object[] messageArgs;
    @ListType(value=ButtonTemplate.class)
    private final List<ButtonTemplate> buttons;
    private final boolean closable;

    public String toString() {
        return "DialogTemplate{titleKey='" + this.titleKey + "', messageKey='" + this.messageKey + "'}";
    }

    public static DialogTemplateBuilder builder() {
        return new DialogTemplateBuilder();
    }

    public DialogTemplate(String titleKey, String messageKey, Object[] messageArgs, List<ButtonTemplate> buttons, boolean closable) {
        this.titleKey = titleKey;
        this.messageKey = messageKey;
        this.messageArgs = messageArgs;
        this.buttons = buttons;
        this.closable = closable;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public List<ButtonTemplate> getButtons() {
        return this.buttons;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public static class DialogTemplateBuilder {
        private String titleKey;
        private String messageKey;
        private Object[] messageArgs;
        private List<ButtonTemplate> buttons;
        private boolean closable;

        DialogTemplateBuilder() {
        }

        public DialogTemplateBuilder titleKey(String titleKey) {
            this.titleKey = titleKey;
            return this;
        }

        public DialogTemplateBuilder messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public DialogTemplateBuilder messageArgs(Object[] messageArgs) {
            this.messageArgs = messageArgs;
            return this;
        }

        public DialogTemplateBuilder buttons(List<ButtonTemplate> buttons) {
            this.buttons = buttons;
            return this;
        }

        public DialogTemplateBuilder closable(boolean closable) {
            this.closable = closable;
            return this;
        }

        public DialogTemplate build() {
            return new DialogTemplate(this.titleKey, this.messageKey, this.messageArgs, this.buttons, this.closable);
        }

        public String toString() {
            return "DialogTemplate.DialogTemplateBuilder(titleKey=" + this.titleKey + ", messageKey=" + this.messageKey + ", messageArgs=" + Arrays.deepToString(this.messageArgs) + ", buttons=" + this.buttons + ", closable=" + this.closable + ")";
        }
    }
}

