package ch.sahits.game.openpatrician.model;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2019
 * Created on Jan 05, 2019
 */
public interface IDateService {
    /**
     * Check if two dates represent the same day
     * @param date1 first date to compair
     * @param date2 second date to compair
     * @return true if both dates are on the same day
     */
    boolean isSameDay(LocalDateTime date1, LocalDateTime date2);

    /**
     * Check if the date is today.
     * @param date to chack against the current date
     * @return true if <code>date</code> is on the same day as current date
     */
    boolean isToday(LocalDateTime date);
    
    /**
     * Check if a date lies in the past.
     * @param date to be checked.
     * @return true if the date is before the current game date
     */
    boolean isPast(LocalDateTime date);

    /**
     * Calculate the percentage of days passed between the start and end date.
     * @param start date
     * @param end date
     * @return percentage of days passed in [0,1]
     */
    double getPercentageBetweenDates(LocalDateTime start, LocalDateTime end);

    /**
     * Calculate the age.
     * @param birthDate from which to calculate the age
     * @return age in years
     */
    int getAge(LocalDateTime birthDate);
}
