package ch.sahits.game.openpatrician.model.building;
/**
 * Basic interface defining the town houses
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface ITownHouse extends IBuilding {
	/**
	 * retrieve the capacity of the house
	 * @return capacity of inhabitants
	 */
	int getCapacity();
	/**
	 * Retrieve the occupancy of the house
	 */
	int getOccupancy();
	/**
	 * Compute the rental income for one day
	 * @return rental income per day
	 */
	int computeRentalIncome();
	/**
	 * Retrieve the rent a tenant has to pay per month
	 */
	void getRentPerTenant();
}
