package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.city.ProductionStorage;
import ch.sahits.game.openpatrician.model.product.IWare;

/**
 * This interface represents a workshop, which employs workers
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 22, 2012
 *
 */
public interface IWorkShop extends IBuilding {
	/**
	 * Retrieve the number of workers in the shop
	 * @return numer of workers
	 */
	int getWorkers();
	/**
	 * Retrieve the number of workers maximal employable by this shop
	 * @return max number of workers
	 */
	int getMaxWorkers();
	/**
	 * Retrieve the salary a worker earns within a week
	 * @return salery per worker and per week
	 */
	int getSalaryPerWorker();

	/**
	 * Retrieve the ware this workshop produces.
	 * @return ware that is produce by the workshop
	 */
	IWare getProducableWare();

	/**
	 * Retrieve the storage of the workshop.
	 * @return Production storage associated with the workshop
	 */
	ProductionStorage getStorage();

	/**
	 * Indicating if the produced ware is produced efficiently in the city.
	 * @return true if the workshop produces the ware efficiently
	 */
	boolean isProducingEfficienty();
}
