package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.city.impl.ECityLabelAlignment;
import javafx.geometry.Point2D;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 06, 2015
 */
public interface IFutureTowns {
    /**
     * Retrieve the town name
     * @return name of the city to be founded.
     */
    String getName();

    /**
     * Retrieve future town location.
     * @return coordinates of the citiy to be founded
     */
    Point2D getLocation();

    /**
     * check if the town is on a river.
     * @return true if the city to be founded lies on a river.
     */
    boolean isRiver();

    /**
     * Alignemnt for the city label.
     * @return alignemnt of the city label
     */
    ECityLabelAlignment getCityLabelAlignment();

    /**
     * Offset for the city label.
     * @return offset of the city label
     */
    Point2D getCityLabelOffset();
}
