package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

/**
 * Singleton bean holding all city halls.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Aug 28, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class CityHallList implements Iterable<ICityHall> {
    @ListType(ICityHall.class)
    private List<ICityHall> cityHalls = new ArrayList<>();

    @Override
    public Iterator<ICityHall> iterator() {
        return cityHalls.iterator();
    }

    public int size() {
        return cityHalls.size();
    }

    public boolean isEmpty() {
        return cityHalls.isEmpty();
    }

    public ICityHall get(int index) {
        return cityHalls.get(index);
    }

    public boolean add(ICityHall iCityHall) {
        return cityHalls.add(iCityHall);
    }

    public Optional<ICityHall> findCityHall(ICity city) {
        for (ICityHall cityHall : cityHalls) {
            if (cityHall.getCity().equals(city)) {
                return Optional.of(cityHall);
            }
        }
        return Optional.empty();
    }
}
