package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.city.ICity;

import java.time.LocalDateTime;

/**
 * Violation of a city against the hanseatic customs.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICityViolation {
    /**
     * City that violated the customs.
     * @return city that commited the violation
     */
    ICity getCity();

    /**
     * Date when the violation was brought to the notice of the alderman.
     * @return when the violation was brought forward.
     */
    LocalDateTime getDate();

    /**
     * Retrieve the proposed punishment for the violation.
     * @return proposed punishment for hte violation
     */
    ECityViolationPunishment getPunishment();
}
