package ch.sahits.game.openpatrician.model.city.cityhall;

import javafx.geometry.Point2D;

/**
 * Found a new settlement.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface IFoundNewSettlement extends IAldermanTask {
    /**
     * Location of the city to be founded.
     * @return location where to found a new city.
     */
    Point2D getLocation();

    /**
     * Get the city name.
     * @return name of the new city.
     */
    String getName();
    /**
     * check if the town is on a river.
     * @return true if the new city is located at a river.
     */
    boolean isRiver();
}
