package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.Iterator;

/**
 * Tracking the contibutions of ware over the last seven days rolling.
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 24, 2012
 *
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class Contributions {

	@Autowired
	private Date date;
	@MultimapType(key=IWare.class, value = Contribution.class)
	private Multimap<IWare, Contribution> contributions = ArrayListMultimap.create();


	/**
	 * Retrieve the contribution for the whole week
	 * @param ware for thitch to find the contribution
	 * @return summed up contributions of the last wek.
	 */
	public int getContribution(IWare ware){
		int sum = 0;
		LocalDateTime lastWeek = date.getCurrentDate().minusDays(7);
		for (Iterator<Contribution> iterator = contributions.get(ware).iterator(); iterator.hasNext(); ) {
			Contribution contrib = iterator.next();

			if (contrib.getTimestamp().isBefore(lastWeek)) {
				iterator.remove();
			} else {
				sum += contrib.getAmount();
			}
		}
		return sum;
	}
	/**
	 * Contribute the amount of the ware. the amount may be possitive or negative
	 * @param ware that is contributed
	 * @param amount of the contributed ware
	 */
	public void contribute(IWare ware,int amount){
		LocalDateTime now = date.getCurrentDate();
		LocalDateTime lastWeek = date.getCurrentDate().minusDays(7);
		if (contributions.containsKey(ware)) {
			contributions.get(ware).removeIf(contrib -> contrib.getTimestamp().isBefore(lastWeek));
		}
		contributions.put(ware, new Contribution(now, amount, ware));
	}
}
