package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Shipyard properties.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Jun 01, 2018
 */
@Component
@PropertySource("classpath:application.properties")
@ConfigurationProperties(prefix = "shipyard")
@Getter
@Setter
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class ShipyardProperties {
    private int materialCostPerUnit;
    private int salaryPerDay;
}
