package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 10, 2016
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class NewPirateEvent implements IEventMetaDataProvider {
    private final ISeaPirate pirate;
    private String className;
    private String methodName;

    public NewPirateEvent(ISeaPirate pirate) {
        this.pirate = pirate;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
