package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Event indicating that a person in the city left the tavern.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Mar 2, 2013
 *
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class PersonLeavesTavernEvent implements IEventMetaDataProvider {
	private final ICity city;
	private final IPerson person;
	private String className;
	private String methodName;

	public PersonLeavesTavernEvent(ICity city, IPerson person) {
		super();
		this.city = city;
		this.person = person;
		StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
		methodName = creatingStackFrame.getMethodName();
		className = creatingStackFrame.getClassName();
	}


}
