package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.EventBus;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 03, 2015
 */
@Getter
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class TargetedEvent implements IEventMetaDataProvider {
    private final IHumanPlayer player;
    private final Object event;
    private String className;
    private String methodName;
    @ListType(EventBus.class)
    private List<EventBus> eventbusBlackList = new ArrayList<>();

    public TargetedEvent(IHumanPlayer player, Object event) {
        this.player = player;
        this.event = event;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }

    public TargetedEvent(IHumanPlayer player, Object event, List<EventBus> eventbusBlackList) {
        this(player, event);
        this.eventbusBlackList = eventbusBlackList;
    }

    /**
     * Add an eventbus to the blacklist, so that events are not propagated onto that eventbus. Usually this is to avoid
     * circular events.
     * @param blacklisted eventbus that should be blacklisted.
     */
    public void addToBlackList(EventBus blacklisted) {
        eventbusBlackList.add(blacklisted);
    }
}
