package ch.sahits.game.openpatrician.model.event;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.UUID;

/**
 * Timed task with a specified execution time. The run method is
 * supposed to be executed at the execution time.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 28, 2013
 *
 */
@Getter
@Setter
@EqualsAndHashCode
public abstract class TimedTask implements Runnable {

    private LocalDateTime executionTime;
    private final UUID uuid;

    protected TimedTask() {
        uuid = UUID.randomUUID();
    }

}
