package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.DefaultCreditor;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * A citizen is an inhabitatant of a town, who does not directly partake in
 * the game play. There may be interactions with citizens (e.g. loans).
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
@RequiredArgsConstructor
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Citizen extends DefaultCreditor implements ICitizen {
    @Getter
    private final String lastName;
    @Getter
    private final String name;
    @Getter
    private final ESocialRank rank;
    @Getter
    private final ICity hometown;
}
